<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>VersaPro Installer</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f4f4f4;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .installer-container {
            background-color: #fff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
            width: 450px;
            text-align: center;
        }
        .logo {
            max-width: 100px;
            margin-bottom: 10px;
        }
        .installer-container h1 {
            margin-bottom: 20px;
            font-size: 26px;
            color: #333;
        }
        .installer-container label {
            display: block;
            text-align: left;
            margin-bottom: 5px;
            font-weight: 600;
            color: #555;
        }
        .installer-container input {
            width: calc(100% - 22px);
            padding: 12px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 16px;
        }
        .installer-container input[type="submit"], .finish-btn {
            background-color: #28a745;
            color: #fff;
            border: none;
            padding: 12px 25px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 18px;
            width: 100%;
        }
        .installer-container input[type="submit"]:hover, .finish-btn:hover {
            background-color: #218838;
        }
        .message {
            margin-bottom: 10px;
            font-size: 14px;
            padding: 10px;
            border-radius: 4px;
            display: none;
        }
        .error-message {
            color: #fff;
            background-color: #ff4d4d;
        }
        .success-message {
            color: #fff;
            background-color: #28a745;
        }
        .progress-bar {
            width: 0;
            height: 10px;
            background-color: #4caf50;
            margin-bottom: 10px;
        }
        .progress-container {
            width: 100%;
            background-color: #f3f3f3;
            border: 1px solid #ddd;
            display: none;
        }
        .finish-btn {
            display: none;
            margin-top: 15px;
        }
    </style>
</head>
<body>
    <div class="installer-container">
        <img class="logo" src="https://i.ibb.co/0R58sRHn/ic-launcher-playstore.png" alt="Logo">
        <h1>VersaPro Installer</h1>

        <div class="message error-message" id="error-message"></div>
        <div class="message success-message" id="success-message"></div>

        <form id="installer-form">
            <label for="db_server">Database Server</label>
            <input type="text" id="db_server" name="db_server" value="localhost" required>

            <label for="db_username">Database Username</label>
            <input type="text" id="db_username" name="db_username" required>

            <label for="db_password">Database Password</label>
            <input type="password" id="db_password" name="db_password">

            <label for="db_name">Database Name</label>
            <input type="text" id="db_name" name="db_name" required>

            <label for="base_url">Base URL</label>
            <input type="url" id="base_url" name="base_url" required>

            <input type="submit" value="Test and Connect">
        </form>

        <div id="progress-container" class="progress-container">
            <div class="progress-bar" id="progress-bar"></div>
        </div>

        <button class="finish-btn" id="finish-btn">Finish</button>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const form = document.querySelector('#installer-form');
            const progressContainer = document.querySelector('#progress-container');
            const progressBar = document.querySelector('#progress-bar');
            const errorMessage = document.querySelector('#error-message');
            const successMessage = document.querySelector('#success-message');
            const finishBtn = document.querySelector('#finish-btn');

            // Validate Base URL to ensure it ends with '/'
            document.querySelector('#base_url').addEventListener('blur', function () {
                if (!this.value.endsWith('/')) {
                    this.value += '/';
                }
            });

            form.addEventListener('submit', function (event) {
                event.preventDefault();
                const formData = new FormData(form);

                errorMessage.style.display = 'none';
                successMessage.style.display = 'none';
                progressContainer.style.display = 'none';
                finishBtn.style.display = 'none';

                fetch('installer_ajax.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        successMessage.textContent = data.message;
                        successMessage.style.display = 'block';

                        progressContainer.style.display = 'block';
                        let progress = 0;
                        const interval = setInterval(() => {
                            if (progress < 100) {
                                progress += 20;
                                progressBar.style.width = progress + '%';
                            } else {
                                clearInterval(interval);
                                progressContainer.style.display = 'none';
                                successMessage.textContent = "Installation completed successfully!";
                                
                                // Show Finish Button
                                setTimeout(() => {
                                    finishBtn.style.display = 'block';
                                }, 1000);
                            }
                        }, 500);
                    } else {
                        errorMessage.textContent = data.message;
                        errorMessage.style.display = 'block';
                    }
                })
                .catch(error => {
                    errorMessage.textContent = "An error occurred.";
                    errorMessage.style.display = 'block';
                });
            });

            // Redirect to Base URL on Finish
            finishBtn.addEventListener('click', function () {
                const baseUrl = document.querySelector('#base_url').value;
                window.location.href = baseUrl;
            });
        });
    </script>
</body>
</html>
